<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('report.stock_report') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                {!! Form::open(['url' => action('ReportController@getStockReport'), 'method' => 'get', 'id' => 'stock_report_filter_form' ]) !!}
                <!-- Existing code for other filter fields -->

                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('is_active', __('product.is_active') . ':') !!}
                        {!! Form::select('is_active', [
                            '1' => __('lang_v1.yes'),
                            '0' => __('lang_v1.no')
                        ], request()->input('is_active', '1'), ['class' => 'form-control select2', 'style' => 'width:100%']); !!}
                    </div>
                </div>

                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @can('view_product_stock_value')
                @component('components.widget', ['class' => 'box-solid'])
                    @include('report.partials.stock_report_table')
                @endcomponent
            @endcan
        </div>
    </div>
</section>
<!-- /.content -->

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
@endsection
